class AdvancedUserRecipe1289709253(BasicNewsRecipe):
    title          = u'BBC Blogs'
    oldest_article = 30
    max_articles_per_feed = 150
    summary_length         = 100
    use_embedded_content  = False
    no_stylesheets = True
    encoding              = 'utf8'

    remove_javascript     = True
    extra_css = '''
        h1{font-family:Georgia,serif; font-weight:bold;font-size:large;}
        h2{font-family:Georgia,serif; font-weight:normal;font-size:small;}
        p{font-family:Georgia,serif;font-size:small;}
        body{font-family:Georgia,serif;font-size:small;}
        '''

    
    keep_only_tags = [dict(name='div',attrs={'class':'post'})]
    remove_attributes = ['style', 'font']
    remove_tags = [dict(name='div', attrs={'class':['meta','imgCaption','stats','imgCaptionCenter','imgCaptionLeft']}),
                   dict(name='div', attrs={'id':['comments','thumb',]}),
                   dict(name='ul', attrs={'class':['ami_social_bookmarks']}),
                   dict(name='ul', attrs={'id':['']}),
                   dict(name='ol', attrs={'id':['']}),
                   dict(name='span', attrs={'class':['']}),
                   dict(name='p', attrs={'id':''}),
                   dict(name='img'),]

    feeds          = [(u'Panorama', u'http://www.bbc.co.uk/blogs/panorama/index.xml'), 
                          (u'TV', u'http://www.bbc.co.uk/blogs/tv/rss.xml'), 
                          (u'Comedy', u'http://www.bbc.co.uk/blogs/comedy/rss.xml'), 
                          (u'BBC3', u'http://www.bbc.co.uk/blogs/bbcthree/rss.xml')]
						  
    def preprocess_html(self, soup):
        for alink in soup.findAll('a'):
            if alink.string is not None:
               tstr = alink.string
               alink.replaceWith(tstr)
        return soup
		
    def parse_feeds (self): 
      feeds = BasicNewsRecipe.parse_feeds(self) 
      for feed in feeds:
        for article in feed.articles[:]:
          print 'article.title is: ', article.title
          if 'GALLERY' in article.title.upper():
            feed.articles.remove(article)
          elif 'VIDEO' in article.url.upper():
            feed.articles.remove(article)
      return feeds